<?php
class MFN_Options_visual extends Mfn_Options_field
{

	/**
	 * Render
	 */

	public function render( $meta = false )
	{

		$preview = '';

		// preview

		if ( ! empty( $this->field['preview'] ) ){
			$preview = 'preview-'. $this->field['preview'];
		}

		// output -----

		echo '<div class="form-group visual-editor">';
			echo '<div class="form-control">';

				echo '<div class="wp-core-ui wp-editor-wrap tmce-active">';

					if ( 'false' != get_user_option( 'syntax_highlighting' ) ){

					

						echo '<div class="wp-editor-tools hide-if-no-js">';
							echo '<div class="wp-media-buttons">';
								echo '<button type="button" class="button insert-media add_media" data-editor="mfn-editor"><span class="wp-media-buttons-icon"></span> Add Media</button>';
							echo '</div>';
							echo '<div class="wp-editor-tabs">';
								echo '<button type="button" class="wp-switch-editor switch-tmce" data-wp-editor-id="mfn-editor">Visual</button>';
								echo '<button type="button" class="wp-switch-editor switch-html" data-wp-editor-id="mfn-editor">Text</button>';
							echo '</div>';
						echo '</div>';

					}

					echo '<div class="wp-editor-container">';
						echo '<textarea class="editor wp-editor-area '. esc_attr( $preview ) .'" '. $this->get_name( $meta ) .' data-visual="mce" rows="8">'. esc_textarea( $this->value ) .'</textarea>';
					echo '</div>';

				echo '</div>';

			echo '</div>';
		echo '</div>';

		echo $this->get_description();

		// enqueue

		$this->enqueue();

	}

	/**
	 * Enqueue
	 */

	public function enqueue()
	{
		$localize = array(
			'mfnsc' => get_theme_file_uri( '/functions/tinymce/plugin.js' ),
		);

		wp_enqueue_media();

		wp_enqueue_script( 'mfn-opts-field-visual', MFN_OPTIONS_URI .'fields/visual/field_visual.js', array( 'jquery' ), MFN_THEME_VERSION, true );
		wp_localize_script( 'mfn-opts-field-visual', 'fieldVisualJS', $localize);
	}

}
